<?php
/*
	DevSaver Web Framework
	Copyright (c) 2002-2018 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com
*/

if (!defined("STPBase")) {
	die("This file can't be accessed directly!");
}
// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CSettings extends CPlugin{
	
	var $tplvars; 

	function __construct() {
		//$this->CPlugin($db, $tables , $templates);
	}

	function DoEvents(){
		global $base, $_CONF, $_TSM , $_VARS , $_USER , $_BASE , $_SESS;

		parent::DoEvents();

		$this->__init();
		$this->PageProtection();
		$this->GoogleSettings();
		$this->FacebookSettings();
		$this->BingSettings();
		$this->GenericSettings();
	}


	function __init() {
		global $_CONF;

		if ($this->__inited) {
			return "";
		}

		$this->__inited = true;
		
		$path = $this->tpl_path;

		$templates = array(
			"google"		 => "google.htm",
			"facebook"		 => "facebook.htm",
		);

		foreach ($templates as $key => $val) {
			$this->private->templates[$key] = new CTemplateDynamic(
				$path . $val
			);
		}
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function GoogleSettings() {

		global $_TSM;

		//google webmaster tools
		if ($this->vars->data["set_google_wa_code"]) {
			$this->plugins["seo"]->AppendToHead(
				$this->vars->data["set_google_wa_code"]
			);		
		}

		//google analytics code
		if ($this->vars->data["set_google_analytics_status"]) {

			switch ($this->vars->data["set_google_analytics_code_type"]) {
				//universall code
				case "1":
					$this->plugins["seo"]->AppendToHead(
						$this->_t("google")->blockReplace(
							"Universal",
							array(
								"SET_GOOGLE_ANALYTICS_ID"	=> $this->vars->data["set_google_analytics_id"],
							)
						)
					);
				break;

				//gtag ( newest version)
				case "2":
					$this->plugins["seo"]->AppendToHead(
						$this->_t("google")->blockReplace(
							"Gtag",
							array(
								"SET_GOOGLE_ANALYTICS_ID"	=> $this->vars->data["set_google_analytics_id"],
							)
						)
					);
				break;

				//custom code
				case "3":
					$this->plugins["seo"]->AppendToHead($this->vars->data["set_google_analytics_script"]);
				break;

			}
			
		}			
	}
	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function FacebookSettings() {
		global $_TSM;
		if ($this->vars->data["set_facebook"]) {
			$this->plugins["seo"]->AppendToBody(
				$this->private->templates["facebook"]->blockReplace(
					"Code",
					array(
						"SET_FACEBOOK_APP"	=> $this->vars->data["set_facebook_app"],
					)
				)
			);		
		}		
	}

	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function GenericSettings() {
		global $_TSM;

		$this->plugins["seo"]->AppendToHead($this->vars->data["set_generic_head"]);

		$this->plugins["seo"]->AppendToBody($this->vars->data["set_generic_body"]);
		$this->plugins["seo"]->PrependToBody($this->vars->data["set_generic_body_head"]);
	}
	

	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function BingSettings() {
		global $_TSM;

		$this->plugins["seo"]->AppendToHead($this->vars->data["set_bing_code"]);
	}
	


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function onGlobalHooksExecute($module) {
		global $_CONF , $_TSM;

		//check for protected module

		$changed	= false;
		$protocol	= ($_SERVER["HTTPS"] ? "https://" : "http://" );
		$domain		=  $_SERVER["HTTP_HOST"];
		$link		= $_SERVER["REQUEST_URI"];			


		$prefix = strtolower(substr($_SERVER["HTTP_HOST"], 0 , 4));

		$this->plugins["redirects"]->CheckSSL($module);

/*
		if (( $prefix == "www.") && ($this->vars->data["set_site_prefix"] != "www")) {
			$changed = true;
			$domain		=  substr($_SERVER["HTTP_HOST"] , 4);
		}
		
		if (( $prefix != "www.") && ($this->vars->data["set_site_prefix"] == "www")) {
			$changed = true;
			$domain		=  "www." . $_SERVER["HTTP_HOST"] ;
		}
*/


		//favicon 

		if (file_exists("upload/favicon.png")) {
			$this->plugins["seo"]->AppendToHead(
				"\t\t<link rel=\"icon\" type=\"image/png\" href=\"". $_CONF["url"] . "upload/favicon.png\" />"
			);
		}		


		//mobile settings

		if ($this->vars->data["set_ios_icon"]) {
			$this->plugins["seo"]->AppendToHead("
			<link rel=\"apple-touch-icon\" href=\"{$_CONF[url]}upload/ios-iphone-touch-icon.png\">
			<link rel=\"apple-touch-icon\" sizes=\"76x76\" href=\"{$_CONF[url]}upload/ios-ipad-touch-icon.png\">
			<link rel=\"apple-touch-icon\" sizes=\"120x120\" href=\"{$_CONF[url]}upload/ios-ipad-retina-touch-icon.png\">
			<link rel=\"apple-touch-icon\" sizes=\"152x152\" href=\"{$_CONF[url]}upload/touch-icon.png\">");
		}
		if ($this->vars->data["set_ios_loader"]) {
			$this->plugins["seo"]->AppendToHead("
			<link rel=\"apple-touch-startup-image\" href=\"{$_CONF[url]}upload/touch-loader.png\">");
		}

		if ($this->vars->data["set_ios_web_app_capable"]) {
			$this->plugins["seo"]->AppendToHead("
			<meta name=\"apple-mobile-web-app-capable\" content=\"{$this->vars->data[set_ios_web_app_capable]}\">
			<meta name=\"mobile-web-app-capable\" content=\"{$this->vars->data[set_ios_web_app_capable]}\">");
		}

		if ($this->vars->data["set_ios_mobile_title"]) {
			$this->plugins["seo"]->AppendToHead("
			<meta name=\"apple-mobile-web-app-title\" content=\"{$this->vars->data[set_ios_mobile_title]}\" >
			<meta name=\"mobile-web-app-title\" content=\"{$this->vars->data[set_ios_mobile_title]}\">");
		}

		if ($this->vars->data["set_ios_web_app_bar_style"]) {
			$this->plugins["seo"]->AppendToHead("
			<meta name=\"apple-mobile-web-app-status-bar-style\" content=\"{$this->vars->data[set_ios_web_app_bar_style]}\">");
		}		
			
	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function PageProtection() {
//		header("X-Frame-Options: DENY");
//		header("x-xss-protection: 1; mode=block");
//		header("X-Content-Type-Options: nosniff");

		if ($_SERVER["HTTPS"]) {
			header("Strict-Transport-Security:max-age=63072000");
		}
		
	}
	
}

?>